#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>
#include <cstring>

using namespace std;

const int MAX_N = 2005;
const int MOD = 1000000007;

int n, x;
long long d;
int dp[2][MAX_N];

int powMod(int n, int k) {
    if (k == 0) {
        return 1;
    }

    int x = powMod(n, k / 2);

    x = ((long long)x * x) % MOD;

    if (k & 1) {
        x = ((long long)x * n) % MOD;
    }

    return x;
}

int mod(int x) {
    if (x >= MOD) {
        x -= MOD;
    }

    return x;
}

int main() {
    ios_base::sync_with_stdio(false);
    //freopen(".in", "r", stdin);
    //freopen(".out", "w", stdout);

    while (cin >> n >> d >> x) {
        if (n == 0 && x == 0 && d == 0) {
            break;
        }

        memset(dp[0], 0, sizeof(dp[0]));

        dp[0][0] = 1;

        int ans = 0, a = 0, b = 1, lim = min((long long)n, d), binomial = 1;

        for (int fullDays = 1; fullDays <= lim; fullDays++) {
            binomial = ((long long)binomial * ((d - fullDays + 1) % MOD)) % MOD;
            binomial = ((long long)binomial * powMod(fullDays, MOD - 2)) % MOD;

            int sum[MAX_N] = {dp[a][0]};

            dp[b][0] = 0;
            for (int i = 1; i <= n; i++) {
                sum[i] = mod(sum[i - 1] + dp[a][i]);

                dp[b][i] = sum[i - 1];

                if (i - x >= 0) {
                    dp[b][i] = mod(dp[b][i] - sum[i - x] + MOD);
                }
            }

            int cur_ans = ((long long)binomial * dp[b][n]) % MOD;
            ans = mod(ans + cur_ans);
            
            swap(a, b);
        }

        cout << ans << endl;
    }

    return 0;
}
